#!/bin/sh

MESAVERS=$( glxinfo | grep "OpenGL version" | cut -d " " -f 6 )

mesa_compare_versions () {
    verA=$(($(echo "$1" | sed 's/\([0-9]*\)\.\([0-9]*\)\.\([0-9]*\).*/\1 \* 10000 + \2 \* 100 + \3/')))
    verB=$(($(echo "$3" | sed 's/\([0-9]*\)\.\([0-9]*\)\.\([0-9]*\).*/\1 \* 10000 + \2 \* 100 + \3/')))
    
    test $verA -$2 $verB
}

if mesa_compare_versions "$MESAVERS" lt "6.5.3" ; then
  LIBGL_ALWAYS_INDIRECT=1 ./dieplaneten
  echo "Direct Rendering disabled"
  echo "You should upgrade your Mesa libraries (>= 6.5.3)."
else
  ./dieplaneten
fi  
